#ifndef INC_MAX31855_H_
#define INC_MAX31855_H_

#include "main.h"
#include <stdbool.h>
#include <math.h>

extern bool initialized;

#define MAX31855_FAULT_NONE (0x00)
#define MAX31855_FAULT_OPEN (0x01)
#define MAX31855_FAULT_SHORT_GND (0x02)
#define MAX31855_FAULT_SHORT_VCC (0x04)
#define MAX31855_FAULT_ALL (0x07)

#define SPI_DELAY 0xFF

bool begin(void);
double readInternal(void);
double readCelsius(void);
double readFahrenheit(void);
uint8_t readError();
void setFaultChecks(uint8_t faults);
uint32_t spiRead32(void);

#endif /* INC_MAX31855_H_ */
